CREATE OR REPLACE FUNCTION ADDCOLUMN()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                FROM information_schema.columns     
                WHERE table_name = 'rc_mdl_venda' 
                  and column_name='num_max_parc_extra'
	) THEN
           RAISE NOTICE 'Coluna  num_max_parc_extra  na tabela  rc_mdl_venda  ja existe!' ;
    ELSE
		ALTER TABLE public.rc_mdl_venda ADD num_max_parc_extra int NOT NULL DEFAULT 0;
        RAISE NOTICE 'Coluna "num_max_parc_extra" criada com sucesso!';
    END IF; 
    
END; 


$BODY$
LANGUAGE PLPGSQL VOLATILE  COST 100;
ALTER FUNCTION ADDCOLUMN()  OWNER TO POSTGRES;
SELECT ADDCOLUMN();
DROP FUNCTION ADDCOLUMN();
